; 14-Aug-07 NEHolt; changes for 2009 release
; 22-Dec-06 NEHolt; added Aw_debug command trace support to make it easier to troubleshoot start-up issues
; 13-Jul-06 NEHolt; added error chk to trap "positive -2" error message
; 23-Mar-06 NEHolt; intial changes for 2008 release
; 24-Jan-06 NEHolt; revised for 2007 release
; 18-Aug-04 NEHolt; renamed wd_exe.vlx to ace_main.vlx and wd_exe2.vlx to ace_conversion.vlx
; 16-Aug-04 NEHolt; set up to load new wd_exe2.vlx (Promis-E conversion toolset)
; 16-Jul-04 PanQ; Change to support MDI
; 10-May-04 LeeH; globalized replace of 'strcase' with 'ace_strcase'
; 08-Apr-04 LeeH; modified 'wd_load' missing 'wd.env' file error handling
; 20-Oct-04 NEHolt added commented out "debug enable" lines
; 29-Mar-04 Lee Hollingworth/LEEH; globalization of "patch" utility strings.
; 15-Aug-03 NEHolt provision for autoload of user "patch" utilities (".lsp" or ".vlx"). Utility must
;    be in the main "c:\program files\autodesk\acade 2004" folder AND have the substring "patch"
;    somewhere in the file name (not the path).
; 23-Jul-03 NEHolt changes to deal with arx and vlx preloaded into memory as ACAD starts up
; 13-Jun-03 NEHolt changes for new install folder setup; removed R14 references
; 18-Mar-03 NEHolt minor edit to make sure that call to (c:wd_rightclickon) cannot
;    be called more than one time during the WD session
; 12-Feb-03 NEHolt - clean-up for 2004 release
; -------------  W D _ L O A D . L S P  -------------------

; ***** Uncomment line below (remove ";" char from 1st char position) to force AcadE into "debug Trace mode" right from startup
;(setq Aw_debug 1)
; *****
(if Aw_debug (princ "\nIN:wd_load.lsp - APPLOAD"))
; 16-Jul-04 PanQ; Change to support MDI
(if (= (getvar "SDI") 1)
  (setvar "LISPINIT" 0)  ; don't reset LISP variables when going from
                       ; one drawing to the next
)
; ** 07-Dec-05; LeeH DID 711741
(defun forceload ( / PreUndoCtlVal PreCmdEchoVal )
  (defun DoIt ( /  x)
    (if (= (getvar "SDI") 1)
      (setvar "LISPINIT" 0) ;Don't reset lisp vars from drawing to drawing
    )

    (if (and (not (boundp 'acade-demand-load)) (setq x (findfile "acade_demandload.fas")))
      (load x)
    )

    (if (boundp 'ace_lisp_loaded) (ace_lisp_loaded)) ; notify AceMDIGblManager that the lisp has been loaded.
  )

  (setq PreUndoCtlVal (getvar "UNDOCTL")) ;get undoctl var
  (setq PreCmdEchoVal (getvar "CMDECHO")) ;get comecho var

  (if (= 1 PreCmdEchoVal) ;if cmdecho is 1 set it to 0
     (setvar "CMDECHO" 0)
  )

  (if (= 1 (logand PreUndoCtlVal 1)) ;undo func is enabled
     (command "_.undo" "_control" "_none") ;disable the undo function, to prevent the follow action be written to the undo list
  )

  (DoIt) ;do whatever we need to do

  (if (= 1 (logand PreUndoCtlVal 1)) ;need to restore the pre-setting of undo
     (progn
        (command "_.undo" "_all") ;enable the undo function again

        (if (= 2 (logand PreUndoCtlVal 2)) ;pre-setting is single step undo
           (command "_.undo" "_control" "_one") ;change setting to only one command can be undone
        ;else
           (if (= 0 (logand PreUndoCtlVal 4));pre-setting is turn-off the selection of Auto
              (command "_.undo" "_auto" "_off") ;turn off auto
           )
        )
     )
  )

  (if (= 1 PreCmdEchoVal) ;change cmdecho var back to 1
     (setvar "CMDECHO" 1)
  )

  ;to check the result
  (setq CurUndoCtlVal (getvar "UNDOCTL")) ;get current undoctl var
  (if (/= CurUndoCtlVal PreUndoCtlVal)
     (princ "fail on undo setting")
  )

)

; **
; ---
; (wd_load) is executed for every AutoCAD Electrical command. If wd_load senses that it
; has already been run during an AutoCAD session, it will make sure
; all database files are closed and then simply return. Otherwise it
; loads up AE's arx and vlx files.
;
(defun wd_load ( / fnam missinglst x str aux_load_lst msg_load dcl_helpid version_number)  
  (setq version_number "2011") ; ** 14-Aug-07 NEHolt
  (if Aw_debug (princ "\nIN:wd_load"))
; ** 07-Dec-05 LeeH
  (if (not (boundp 'acade-demand-load))
    (forceload)
  )
; **

; -** * -*** **- --* 20-Oct-04 NEHolt
;(setq Aw_lock 1) ; enable this line to display alert dialogs for "virtual lock" and lastproj.fil operations
;(setq Aw_debug 1) ; enable this line to turn on command line "command trace" right from AcadE initialization
; -** * -*** **- --*

  (if (boundp 'wd_mdb_mkdir) ; check if wd_mdb.arx in memory   ; ** 10-Jan-03 NEHolt removed old "n8" reference
    (progn
      ; The following will slam shut any mdb files that may be
      ; hanging open because user crashed out of previous command.
      (wd_mdb_CloseAll) ; release any opened mdb file handles
    )
  )    
  (if (not GBL_wd_1)
    (progn ; the c:wd_1 has yet to be run for this Acad session
      (if (boundp 'c:wd_1) ; this should show up if AcadE base executables loaded okay
        (progn
          (setq GBL_wd_DocSetBase "" GBL_wd_DocSetWDBase "" GBL_wd_BaseInstall "" GBL_wd_BaseLibs "")
          ; Set the "Documents and Settings\<user name>\... global
          ; This ROAMABLEROOTPREFIX call should give "c:\doc...\AutoCAD Electrical 2007\...\enu\
          (setq GBL_wd_DocSetBase (wd_4_all_slashes_forward
                         (strcat (getvar "ROAMABLEROOTPREFIX") "Support/"))) 
; ** 24-Jan-06 NEHolt                                                                                          
          ; Check if this folder actually exists (strip off trailing "/" char for this check)                                                  
          (if (not (findfile (substr GBL_wd_DocSetBase 1 (1- (strlen GBL_wd_DocSetBase)))))
            (progn ; Didn't find the "c:/documents and settings/..../Support" folder
                   ; in the expected place.
; ** 24-Jan-06 NEHolt.en                   
              ; There is a possibility that "ROAMABLEROOTPREFIX" pointing at AutoCAD install folder instead
              ; of AcadE install folder. Check it out.
              (if (AND (wcmatch GBL_wd_DocSetBase "*AutoCAD*")
                       (not (wcmatch GBL_wd_DocSetBase "*Electrical*")))
                (progn ; good possibility that ROAMABLEROOTPREFIX is pointing at generic AutoCAD install
                  ; Paste in "Electrical" after the word "AutoCAD" and see if this finds the target
                  ; file.
                  (setq x (wd_1_strchr GBL_wd_DocSetBase "AutoCAD"))
                  (if (> x 0)
                    (progn ; paste in "Electrical
                      (setq GBL_wd_DocSetBase (strcat (substr GBL_wd_DocSetBase 1 (+ x 7)) "Electrical "
                              (substr GBL_wd_DocSetBase (+ x 8))))
                      ; Check if this calculated folder exists
                      (if (not (findfile (substr GBL_wd_DocSetBase 1 (1- (strlen GBL_wd_DocSetBase)))))
                        (progn ; didn't find new folder path with "AutoCAD Electrical" in it.
                          (setq GBL_wd_DocSetBase nil)
                      ) )
          ) ) ) ) ) )  
            
; ** 04-Jan-07 NEHolt - 879631             
          (setq GBL_wd_DocSetWDBase (strcat (wd_4_all_slashes_forward (getvar "MYDOCUMENTSPREFIX"))
                                            "/AcadE " version_number "/AeData/"))
          (if (not (findfile (strcat GBL_wd_DocSetWDBase "wd.env")))
            (progn   
; ** 04-Jan-07 NEHolt.en                                                                                   
; ** 24-Jan-06 NEHolt                                                  
              (setq GBL_wd_DocSetWDBase (strcat (wd_4_all_slashes_forward (getenv "USERPROFILE")) 
                                                "/My Documents/AcadE " version_number "/AeData/"))
          ) )                                      
          ; Check if this calculated folder exists by looking for file "wd.env" in that folder                                  
          (if (not (findfile (strcat GBL_wd_DocSetWDBase "wd.env")))
            (progn ; not found
              (setq GBL_wd_DocSetWDBase "") ; mark it as "not found" 
; ** 24-Jan-06 NEHolt.en
              ; Use regular findfile to try to locate wd.env and therefore identify
              ; the path for GBL_wd_DocSetWDBase
              (setq x (findfile "wd.env"))
              (if x
                (progn ; found wd.env somewhere in ACAD path
                  (setq GBL_wd_DocSetWDBase (car (wd_4_split_fname x)))
                  (if Aw_debug
                    (progn
                      (princ "\n Found relocated \"AeData\" folder =")
                      (princ GBL_wd_DocSetWDBase)
                      (princ "\n")
                ) ) )
              ; ELSE
                (progn ; may be pointing one folder too low, look for "data" subfolder
                  (setq lst (getenv "ACAD")) 
                  (if lst
                    (progn
                      (setq lst (c:wd_delim_str_to_lst lst ";"))
                      (foreach x lst
                        ; Add trailing "\\" char if necessary
                        (if (/= (substr x (strlen x) 1) "\\")
                          (setq x (strcat x "\\")))
                        (if (findfile (strcat x "AeData\\wd.env"))
                          (progn ; found it
                            (setq GBL_wd_DocSetWDBase (strcat x "AeData\\"))
                                  
                            (if Aw_debug
                              (progn
                                (princ "\n Found relocated \"AeData\" folder =")
                                (princ GBL_wd_DocSetWDBase)
                                (princ "\n")
          ) ) ) ) ) ) ) ) ) ) )     
          
          
; ** 04-Dec-08 NEHolt for ACE2010 and above, user can customize lib folder location at installation time.
;         ; Scan ACAD support paths for base library folder          
          (setq lst (getenv "ACAD"))  
          (if lst
            (progn
              (setq lst (c:wd_delim_str_to_lst lst ";"))
                      
              ; Paste in a couple more paths to check                      
              (if (AND GBL_wd_DocSetBase (/= GBL_wd_DocSetBase ""))
                (setq lst (cons (wd_4_all_slashes_backward GBL_wd_DocSetBase) lst)))
              (if (AND GBL_wd_DocSetWDBase (/= GBL_wd_DocSetWDBase ""))
                (setq lst (cons (wd_4_all_slashes_backward GBL_wd_DocSetWDBase) lst)))
                        
              (foreach x lst
                ; Add trailing "\\" char if necessary
                (if (AND (/= (substr x (strlen x) 1) "\\")
                         (/= (substr x (strlen x) 1) "/"))
                  (setq x (strcat x "\\")))
                ; Check if path ends in "\\libs\\"
              (if (AND (> (strlen x) 5) ; ** 13-Jul-06 NEHolt - avoid any "positive -2" error message 
                       (= (ace_strcase (substr x (- (strlen x) 5))) "\\LIBS\\"))
                (progn ; found it as hard-coded path
                  (setq GBL_wd_BaseLibs (wd_4_all_slashes_forward x))
                    (if Aw_debug
                      (progn
                        (princ "\n Found relocated base library folder =")
                        (princ x)
                    ) )
                  )
                ; ELSE
                  (progn ; try pasting "libs" to the path and see if this path exists
                    (if (findfile (strcat x "Libs"))
                      (progn ; okay, assume that we've found it
                        (setq GBL_wd_BaseLibs (strcat (wd_4_all_slashes_forward x) "Libs/"))
                        (if Aw_debug
                          (progn
                            (princ "\n Found relocated base library folder =")
                            (princ GBL_wd_BaseLibs)
                        ) )    
                      )
                    ; ELSE
                      (progn ; no luck yet, try pasting "support\libs" to the path  
                        (if (findfile (strcat x "Support\\Libs"))
                          (progn
                            (setq GBL_wd_BaseLibs (strcat (wd_4_all_slashes_forward x) "Support/Libs/"))
                            (if Aw_debug
                              (progn
                                (princ "\n Found relocated base library folder =")
                                (princ GBL_wd_BaseLibs)
                        ) ) ) )                                   
                    ) )                                
                ) ) 
            ) )
          )
                                                                                 
                                            
; ** 14-Aug-07 NEHolt
          ; Set the shared "All Users" base folder
          
; ** 28-Nov-07           
          (if (AND (not GBL_wd_BaseLibs) ; ** 04-Dec-08 NEHolt
                   (setq x (vl-registry-read 
                 "HKEY_LOCAL_MACHINE\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders"
                 "Common Documents")))
            (progn
              (setq GBL_wd_DocSetAllUsersBase (wd_4_all_slashes_forward (strcat x 
                      "/Autodesk/AcadE " version_number "/")))
              (if (findfile (substr GBL_wd_DocSetAllUsersBase 1 (1- (strlen GBL_wd_DocSetAllUsersBase))))
                (progn ; Found AllUsers base folder. Look for LIBS subfolder here.
                  (if (findfile (strcat GBL_wd_DocSetAllUsersBase "Libs"))
                    (progn 
                      (setq GBL_wd_BaseLibs (strcat GBL_wd_DocSetAllUsersBase "Libs/")) 

                      (if Aw_debug
                        (progn
                          (princ "\n Found GBL_wd_BaseLibs=")
                          (princ GBL_wd_BaseLibs)
                      ) )    
          ) ) ) ) ) )   
          (if (OR (not GBL_wd_BaseLibs) (= GBL_wd_BaseLibs ""))
            (progn
; ** 28-Nov-07 NEHolt.en                                    
              (setq GBL_wd_DocSetAllUsersBase (wd_4_all_slashes_forward
                             (strcat (getenv "ALLUSERSPROFILE") "/Documents/Autodesk/AcadE " version_number "/"))) 
              ; Check if this folder actually exists (strip off trailing "/" char for this check)                                                  
              (if (findfile (substr GBL_wd_DocSetAllUsersBase 1 (1- (strlen GBL_wd_DocSetAllUsersBase))))
                (progn ; Found AllUsers base folder. Look for LIBS subfolder here.
            
                  (if (findfile (strcat GBL_wd_DocSetAllUsersBase "Libs"))
                    (progn 
                      (setq GBL_wd_BaseLibs (strcat GBL_wd_DocSetAllUsersBase "Libs/")) 
                      (if Aw_debug
                        (progn
                          (princ "\n Found GBL_wd_BaseLibs=")
                          (princ GBL_wd_BaseLibs)
                      ) )    
                  ) )
                )
              ; ELSE
                (progn ; Didn't find the "c:/documents and settings/all users/Autodesk/AcadE 2009/" folder
                  ; Give up for now
                  (setq GBL_wd_DocSetAllUsersBase nil)                  
          ) ) ) )
; ** 14-Aug-07 NEHolt.end                                                                                                        

          (if (OR (not GBL_wd_DocSetWDBase)(= GBL_wd_DocSetWDBase ""))
            (progn ; could not find wd.env
; 08-Apr-04.sn LeeH              
              ; To support globalization we do a bit of a work around by loading
              ; a message dialog, extract the title text, then display it with getfiled.
              ; Assume that our globals are not yet set because we can't locate the file
              ; so wdhelp.dcl needs to be in the support path.
              (if (and (/= (setq dcl_helpid (load_dialog "wdhelp.dcl")) -1) (new_dialog "missing_env_file" dcl_helpid))
                 (progn
                     (setq dlg_title (get_tile "title"))
                     (start_dialog)
                     (unload_dialog dcl_helpid)
                 )
              ; else
                 (setq dlg_title "ERROR: Cannot locate wd.env file")
              )
              (setq x (getfiled dlg_title "" "env" 0))
; 08-Apr-04.en
              (if (AND x (/= x ""))
                (progn
                  (setq GBL_wd_DocSetWDBase (wd_4_all_slashes_forward (car (wd_4_split_fname x))))
              ) )
          ) ) 
          (if (AND GBL_wd_DocSetWDBase (/= GBL_wd_DocSetWDBase "")) 
            (setq GBL_wd_DocSetWDBase (wd_4_all_slashes_forward GBL_wd_DocSetWDBase))
          )
          ; Set the base AcadE "Program Files\"... global. This keys off of the location
          ; of one of the key executables: acade_demandload.fas
; ** 24-Jan-06 NEHolt          
          (if (not (setq exefnam (findfile "acade_demandload.fas"))) 
            (setq exefnam (findfile "support/acade_demandload.fas"))) 
; ** 24-Jan-06 NEHolt.en        
          (if exefnam
            (progn
              (setq x (wd_4_split_fname exefnam))
              (setq x (wd_4_all_slashes_forward (ace_strcase (car x) T))) 
              ; Strip off the wd subfolder
              (setq GBL_wd_BaseInstall x)
; ** 14-Aug-07 NEHolt
              (if (OR (not GBL_wd_BaseLibs)
                      (= GBL_wd_BaseLibs "")) ; ** 02-Dec-07 NEHolt
                (progn ; didn't find base libraries in expected place above. Continue looking.
; ** 14-Aug-07 NEHolt.en                
                  ; Look for "libs" folder underneath GBL_wd_BaseInstall (ex: "c:\Program Files\Autodesk\Acade 2004\libs\")
                  (if (findfile (strcat GBL_wd_BaseInstall "Libs"))
                    (progn 
                      (setq GBL_wd_BaseLibs (strcat GBL_wd_BaseInstall "Libs/")) ; ** 24-Jul-03 NEHolt added trailing "/"
                      (if Aw_debug
                        (progn
                          (princ "\n Found GBL_wd_BaseLibs=")
                          (princ GBL_wd_BaseLibs)
                      ) )    
                    )
                  ; ELSE
                    (progn ; may have been relocated. Check ACAD paths for one ending in "libs"
                           ; or support\libs
                  ) ) 
              ) )
          ) )         
; **        
        
          (c:wd_1) ; initialize the executables
          ; Turn on AcadE's "Right Click" menuing feature (WD 2000 and above)
; ** 18-Mar-03 NEHolt          


; 05-Mar-06 NEHolt
          (vl-load-com) ; make sure this initialized
          ; Set up mouse right-click reactor (later controlled by GBL_wd_rightclickoff global
          ; set by c:wd_rightclickoff and c:wd_rightclickon functions.
          (vlr-mouse-Reactor nil '((:vlr-beginRightClick . wd_checkRClick)))
          (vlr-mouse-Reactor nil '((:vlr-beginDoubleClick . wd_checkDClick)))
; ** 05-Mar-06 NEHolt.en



; ** 15-Aug-03 NEHolt
          (if (AND GBL_wd_BaseInstall (boundp 'wd_1a_dir_filelist))
            (progn
              (setq aux_load_lst '())
              (if (setq xx (wd_1a_dir_filelist GBL_wd_BaseInstall "*.lsp" 1 nil))
              ; Filter out all except file names with the substring "patch" in them
                (foreach x xx
                  (if (wcmatch (ace_strcase x) "*PATCH*")
                    (setq aux_load_lst (cons (strcat GBL_wd_BaseInstall x) aux_load_lst))
                  )
              ) )
              (if (setq xx (wd_1a_dir_filelist GBL_wd_BaseInstall "*.vlx" 1 nil))
              ; Filter out all except file names with the substring "patch" in them
                (foreach x xx
                  (if (wcmatch (ace_strcase x) "*PATCH*")
                    (setq aux_load_lst (cons (strcat GBL_wd_BaseInstall x) aux_load_lst))
                  )
              ) )
              (if aux_load_lst
                (progn
; *** 29-Mar-04 LEEH; globalization of patcher strings                
;                  (princ "\n** patch/user utility found\n")
                  (princ (strcat "\n** " (c:wd_msg "LOAD001" nil "patch/user utility found") "\n"))
                  (setq msg_load (strcat "\n" (c:wd_msg "LOAD002" nil "Load/run") " "))
                  (foreach x aux_load_lst
;                    (princ "\nLoad/run ")
;                    (princ x)
;                    (princ "\n")
                    (princ (strcat msg_load x "\n"))
                    (load x) ; Load the lsp or vlx program. 
                  )
                  (princ "\n**\n")
                  (setq aux_load_lst nil)
              ) )
          ) )    
      ) )
; **      
      (if missinglst
        (progn ; one or more files were not found. Alert user.
          (setq str (c:wd_msg "OEMLD001" nil "Required files not found:"))
          (foreach fnam missinglst (setq str (strcat str "\n" fnam)))
          (alert str)
          (setq missinglst nil str nil)
        )
      )
  ) )
  (if Aw_debug (princ "\nOUT:wd_load"))
  (princ)
)

(if (boundp 'ace_add_appwide_variable)
  (progn
    (ace_add_appwide_variable "aw_debug")
    (ace_add_appwide_variable "aw_lock")
    (ace_add_appwide_variable "aw_timer")
  )
)
(if Aw_debug (princ "\nOUT:wd_load.lsp"))
(princ)
